/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.IIncrementalEnum;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public class ModuleExcavationEscalationUnit
implements ICustomModule<ModuleExcavationEscalationUnit> {
    private IModuleConfigItem<ExcavationMode> excavationMode;

    @Override
    public void init(IModule<ModuleExcavationEscalationUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.excavationMode = configItemCreator.createConfigItem("excavation_mode", MekanismLang.MODULE_EFFICIENCY, new ModuleEnumData<ExcavationMode>(ExcavationMode.class, module.getInstalledCount() + 2, ExcavationMode.NORMAL));
    }

    @Override
    public void changeMode(IModule<ModuleExcavationEscalationUnit> module, Player player, ItemStack stack, int shift, boolean displayChangeMessage) {
        if (module.isEnabled()) {
            ExcavationMode newMode = this.excavationMode.get().adjust(shift, v -> v.ordinal() < module.getInstalledCount() + 2);
            if (this.excavationMode.get() != newMode) {
                this.excavationMode.set(newMode);
                if (displayChangeMessage) {
                    module.displayModeChange(player, (Component)MekanismLang.MODULE_EFFICIENCY.translate(new Object[0]), newMode);
                }
            }
        }
    }

    @Override
    public void addHUDStrings(IModule<ModuleExcavationEscalationUnit> module, Player player, Consumer<Component> hudStringAdder) {
        if (module.isEnabled()) {
            hudStringAdder.accept((Component)MekanismLang.DISASSEMBLER_EFFICIENCY.translateColored(EnumColor.DARK_GRAY, EnumColor.INDIGO, this.excavationMode.get().getEfficiency()));
        }
    }

    public float getEfficiency() {
        return this.excavationMode.get().getEfficiency();
    }

    public static enum ExcavationMode implements IIncrementalEnum<ExcavationMode>,
    IHasTextComponent
    {
        OFF(0),
        SLOW(4),
        NORMAL(16),
        FAST(32),
        SUPER_FAST(64),
        EXTREME(128);

        private static final ExcavationMode[] MODES;
        private final Component label;
        private final int efficiency;

        private ExcavationMode(int efficiency) {
            this.efficiency = efficiency;
            this.label = TextComponentUtil.getString(Integer.toString(efficiency));
        }

        @Override
        @Nonnull
        public ExcavationMode byIndex(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public int getEfficiency() {
            return this.efficiency;
        }

        static {
            MODES = ExcavationMode.values();
        }
    }
}

